/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverestore;

import com.ibm.hwmca.base.managed.BaseTower;
import com.ibm.hwmca.base.settings.acctinfo.AccountInfo;
import com.ibm.hwmca.fw.upgrddat.UpgradeData;
import com.ibm.hwmca.fw.upgrddat.UpgradeDataException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.InputStream;
import java.io.OutputStream;

public class UpgradeAccountInfo
implements UpgradeData {
    private static final String TRACE_MASKT = "XSETUNST";
    private static final String TRACE_MASKF = "XSETUNSF";
    private static final String TRACE_MASKD = "XSETUNSD";
    private static final int NUMBER_LEN = 3;
    private static final int CUSTOMER_NUMBER_LEN = 7;
    private static final int COMPANY_NAME_ADDR_LEN = 35;
    private static final int CUSTOMER_CONTACT_LEN = 30;
    private static final int PHONE_NUMBER_LEN = 34;
    public static final short HMC_UPGRADE_ACCTINFO_RESTORE_ERROR = -28672;
    private AccountInfo accountInfo;

    public String getUpgradeDataVersion() throws UpgradeDataException {
        return "1.0";
    }

    public void saveUpgradeData(OutputStream StreamNameOut) throws UpgradeDataException {
    }

    public void restoreUpgradeData(InputStream inStream, String name) throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradeAccountInfo.restoreUpgradeData(" + name + ")");
        try {
            int streamSize = inStream.available();
            byte[] buffer = new byte[streamSize];
            int bytesRead = inStream.read(buffer);
            Trace.trace(TRACE_MASKF, "Bytes read = " + bytesRead);
            if (bytesRead != streamSize) {
                Trace.trace(TRACE_MASKF, "Exception, Bytes read mismatch");
                UpgradeDataException exc = new UpgradeDataException("Bytes read exception, mismatch from inputstream.");
                exc.setCriticalDataError();
                throw exc;
            }
            Trace.trace(TRACE_MASKT, "-> Process iqyvpdpDat");
            this.accountInfo = BaseTower.getBaseTower().getAccountSettings();
            int offset = 0;
            String branchNumber = new String(buffer, offset, 3);
            offset = offset + 3 + 1;
            Trace.trace(TRACE_MASKT, "branchNumber = [" + branchNumber + "]");
            String serviceBranch = new String(buffer, offset, 3);
            offset = offset + 3 + 1;
            Trace.trace(TRACE_MASKT, "serviceBranch = [" + serviceBranch + "]");
            String regionNumber = new String(buffer, offset, 3);
            offset = offset + 3 + 1;
            Trace.trace(TRACE_MASKT, "regionNumber = [" + regionNumber + "]");
            String countryNumber = new String(buffer, offset, 3);
            offset = offset + 3 + 1;
            Trace.trace(TRACE_MASKT, "countryNumber = [" + countryNumber + "]");
            String customerNumber = new String(buffer, offset += 12, 7);
            offset = offset + 7 + 1;
            Trace.trace(TRACE_MASKT, "customerNumber = [" + customerNumber + "]");
            String companyName = new String(buffer, offset, 35).trim();
            offset = offset + 35 + 1;
            Trace.trace(TRACE_MASKT, "companyName = [" + companyName + "]");
            String companyAddress1 = new String(buffer, offset, 35).trim();
            offset = offset + 35 + 1;
            Trace.trace(TRACE_MASKT, "companyAddress1 = [" + companyAddress1 + "]");
            String companyAddress2 = new String(buffer, offset, 35).trim();
            offset = offset + 35 + 1;
            Trace.trace(TRACE_MASKT, "companyAddress2 = [" + companyAddress2 + "]");
            String companyAddress3 = new String(buffer, offset, 35).trim();
            offset = offset + 35 + 1;
            Trace.trace(TRACE_MASKT, "companyAddress3 = [" + companyAddress3 + "]");
            String systemLocation1 = new String(buffer, offset, 35).trim();
            offset = offset + 35 + 1;
            Trace.trace(TRACE_MASKT, "systemLocation1 = [" + systemLocation1 + "]");
            String systemLocation2 = new String(buffer, offset, 35).trim();
            offset = offset + 35 + 1;
            Trace.trace(TRACE_MASKT, "systemLocation2 = [" + systemLocation2 + "]");
            String systemContact = new String(buffer, offset, 30).trim();
            offset = offset + 30 + 1;
            Trace.trace(TRACE_MASKT, "systemContact = [" + systemContact + "]");
            String voiceNumber = new String(buffer, offset, 34).trim();
            offset = offset + 34 + 1;
            Trace.trace(TRACE_MASKT, "voiceNumber = [" + voiceNumber + "]");
            String modemNumber = new String(buffer, offset, 34).trim();
            offset = offset + 34 + 1;
            Trace.trace(TRACE_MASKT, "modemNumber = [" + modemNumber + "]");
            this.accountInfo.setBranchNumber(branchNumber);
            this.accountInfo.setServiceBranch(serviceBranch);
            this.accountInfo.setRegionNumber(regionNumber);
            this.accountInfo.setCountryNumber(countryNumber);
            this.accountInfo.setCustomerNumber(customerNumber);
            this.accountInfo.setCompanyName(companyName);
            this.accountInfo.setCompanyAddress1(companyAddress1);
            this.accountInfo.setCompanyAddress2(companyAddress2);
            this.accountInfo.setCompanyAddress3(companyAddress3);
            this.accountInfo.setSystemLocation1(systemLocation1);
            this.accountInfo.setSystemLocation2(systemLocation2);
            this.accountInfo.setContact(systemContact);
            this.accountInfo.setVoiceNumber(voiceNumber);
            this.accountInfo.setModemNumber(modemNumber);
            this.accountInfo.setCompanyName(companyName);
            BaseTower.getBaseTower().setAccountSettings(this.accountInfo);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "Exception, UpgradeAccountInfo.restoreUpgradeData() = " + exc);
            UpgradeDataException udexc = new UpgradeDataException(exc);
            udexc.setCriticalDataError();
            throw udexc;
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeAccountInfo.restoreUpgradeData");
    }
}

